﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Runtime.Serialization;
using System.Text;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
    //
    public partial class vm_pools
    {
        public vm_pools()
        {
        }

        public vm_pools(System.String vm_pool_description, System.Guid vm_pool_id,
            System.String vm_pool_name, VmPoolType vmPoolType, Guid vds_group_id,
            int defaultTimeInDays,
            TimeSpan defaultStartTime,
            TimeSpan defaultEndTime) :
            this(vm_pool_description, vm_pool_id, vm_pool_name, vmPoolType, vds_group_id)
        {
            DefaultTimeInDays = defaultTimeInDays;
            DefaultStartTime = defaultStartTime;
            DefaultEndTime = defaultEndTime;
        }

        public vm_pools(System.String vm_pool_description, System.Guid vm_pool_id,
            System.String vm_pool_name, VmPoolType vmPoolType, System.Guid vds_group_id)
        {
            this.vm_pool_description = vm_pool_description;
            this.vm_pool_id = vm_pool_id;
            this.vm_pool_name = vm_pool_name;
            this.vm_pool_type = vmPoolType;
			this.vds_group_id = vds_group_id;
        }

        #region IVdcQueryable Members

        [XmlIgnoreAttribute]
        public override object QueryableId
        {
            get { return vm_pool_id; }
        }

        private static readonly List<string> _poolProperties =
						new List<string> { "vm_pool_name", "vm_pool_description", "vm_pool_type", "vm_running_count", "vm_assigned_count", "vds_group_name" };
        [XmlIgnoreAttribute]
        public override List<string> ChangeablePropertiesList
        {
            get { return _poolProperties; }
        }

        #endregion
	}
}

